function Model7Data = StartDynSimM7( TshadowI, TIRF, Var_cons1, Var_cons2, steadymuvalues, var_list_ )

% Code for initiating dynamic simulations with ONBC
%
% INPUTS 
% ------
% TshadowI:      Number of periods you predict the constraint to bind.
% TIRF:         Number of periods to generate impulse response functions for. Must be larger than TshadowI.
% Var_cons:     String with the name of the constrained variable.
% var_list_:    Char Array of variables to generate impulse response functions for
%
% OUTPUTS
% -------
% Model7Data:		Structure containing the required data to call STEADYSTATE_IRF_CONS or AVERAGE_SIMU_CONS
%

	global M_
	
    ZeroVec = zeros( 2*TshadowI, 1 );
	OneVec = ones( size( ZeroVec ) );
    Mmat = zeros( 2*TIRF, 2*TshadowI );
 
	for indx = 0:( TshadowI - 1 )
		Mmat( 1:TIRF, indx + 1 ) = GetRelIRF( Var_cons1, [ 'shadowImp_' int2str( indx ) ], TIRF );
        Mmat( 1:TIRF, indx+1+TshadowI ) = GetRelIRF( Var_cons1, [ 'shadowEnt_' int2str( indx ) ], TIRF );
        Mmat( TIRF+1:end, indx + 1 ) = GetRelIRF( Var_cons2, [ 'shadowImp_' int2str( indx ) ], TIRF );
        Mmat( TIRF+1:end, indx+1+TshadowI ) = GetRelIRF( Var_cons2, [ 'shadowEnt_' int2str( indx ) ], TIRF );
    end
    Mmat(1:TIRF,:)=steadymuvalues(1).*Mmat(1:TIRF,:);
    Mmat( TIRF+1:end, : )=steadymuvalues(2).*Mmat( TIRF+1:end, : );
	%
	dM = diag( Mmat );
	sDM = sign( diag( Mmat ) );
	if min( dM ) <= 0
		warning( 'Model7:MDiagonal', 'Mmat does not have a positive diagonal. Flipping row signs as necessary.' );
		Mmat = Mmat * diag( sDM );
	end

	seps = sqrt( eps );
	CompVec = false( TIRF*2, 1 );
	GuaranteedHorizon = 0;

	for GH = 1:TIRF
		CompVec( GH ) = true;
		AlphaStart = linprog( OneVec, -Mmat, -double( CompVec ), [ ], [ ], ZeroVec, [ ], [ ], optimset( 'display', 'off', 'LargeScale', 'on', 'MaxIter', 1000, 'TolFun', seps ) );
		if ( min( AlphaStart ) < -seps ) || ( min( Mmat( CompVec, : ) * AlphaStart ) < 1-seps ) || ( min( Mmat * AlphaStart ) < -seps )
			warning( 'Model7:AlphaStart', [ 'There is only a guaranteed solution to the linear programming problem when the constraint is non-binding for at most ' int2str( GuaranteedHorizon ) ' periods.' ] );
			break;
		else
			GuaranteedHorizon = GH;
		end
	end
	
	Model7Data = struct;
	Model7Data.ZeroVec = ZeroVec;
	Model7Data.OneVec = OneVec;
	Model7Data.Mmat = Mmat;
	Model7Data.AlphaStart = AlphaStart;
	Model7Data.Options = optimset( 'MaxIter', 4096, 'LargeScale', 'off', 'Algorithm', 'active-set', 'display', 'off', 'TolX', seps, 'TolFun', seps );
	Model7Data.Var_cons1 = Var_cons1;
    Model7Data.Var_cons2 = Var_cons2;
	Model7Data.Accuracy = seps;
	Model7Data.TshadowI = TshadowI;
	Model7Data.TIRF = TIRF;
	Model7Data.ExoVars = M_.exo_names( 1:( M_.exo_nbr - TshadowI ), : );
	Model7Data.Vars = var_list_;
	Model7Data.sDM = sDM;
end
